/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.server;

import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.math.EulerPathFinder;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_18;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class ScrungledPatternsSave
extends class_18 {
    public static final String DATA_VERSION = "0.1.0";
    public static final String TAG_SAVED_DATA = "hexcasting.per-world-patterns.0.1.0";
    private static final String TAG_DIR = "startDir";
    private static final String TAG_KEY = "key";
    private final Map<String, PerWorldEntry> lookup;
    private final Map<class_5321<ActionRegistryEntry>, String> reverseLookup;

    private ScrungledPatternsSave(Map<String, PerWorldEntry> lookup) {
        this.lookup = lookup;
        this.reverseLookup = new HashMap<class_5321<ActionRegistryEntry>, String>();
        this.lookup.forEach((sig, entry) -> this.reverseLookup.put(entry.key, (String)sig));
    }

    @Nullable
    public PerWorldEntry lookup(String signature) {
        return this.lookup.get(signature);
    }

    @Nullable
    public Pair<String, PerWorldEntry> lookupReverse(class_5321<ActionRegistryEntry> key) {
        String sig = this.reverseLookup.get(key);
        if (sig == null) {
            return null;
        }
        return Pair.of((Object)sig, (Object)this.lookup.get(sig));
    }

    public class_2487 method_75(class_2487 tag) {
        this.lookup.forEach((sig, entry) -> {
            class_2487 inner = new class_2487();
            inner.method_10567(TAG_DIR, (byte)entry.canonicalStartDir.ordinal());
            inner.method_10582(TAG_KEY, entry.key().method_29177().toString());
            tag.method_10566(sig, (class_2520)inner);
        });
        return tag;
    }

    private static ScrungledPatternsSave load(class_2487 tag) {
        class_5321 registryKey = IXplatAbstractions.INSTANCE.getActionRegistry().method_30517();
        HashMap<String, PerWorldEntry> map = new HashMap<String, PerWorldEntry>();
        for (String sig : tag.method_10541()) {
            class_2487 inner = tag.method_10562(sig);
            byte rawDir = inner.method_10571(TAG_DIR);
            String rawKey = inner.method_10558(TAG_KEY);
            HexDir dir = HexDir.values()[rawDir];
            class_5321 key = class_5321.method_29179((class_5321)registryKey, (class_2960)new class_2960(rawKey));
            map.put(sig, new PerWorldEntry((class_5321<ActionRegistryEntry>)key, dir));
        }
        return new ScrungledPatternsSave(map);
    }

    public static ScrungledPatternsSave createFromScratch(long seed) {
        HashMap<String, PerWorldEntry> map = new HashMap<String, PerWorldEntry>();
        class_2378<ActionRegistryEntry> registry = IXplatAbstractions.INSTANCE.getActionRegistry();
        for (class_5321 key : registry.method_42021()) {
            ActionRegistryEntry entry = (ActionRegistryEntry)registry.method_29107(key);
            if (!HexUtils.isOfTag(registry, key, HexTags.Actions.PER_WORLD_PATTERN)) continue;
            HexPattern scrungledPat = EulerPathFinder.findAltDrawing(entry.prototype(), seed);
            map.put(scrungledPat.anglesSignature(), new PerWorldEntry((class_5321<ActionRegistryEntry>)key, scrungledPat.getStartDir()));
        }
        ScrungledPatternsSave out = new ScrungledPatternsSave(map);
        out.method_80();
        return out;
    }

    public static ScrungledPatternsSave open(class_3218 overworld) {
        return (ScrungledPatternsSave)overworld.method_17983().method_17924(ScrungledPatternsSave::load, () -> ScrungledPatternsSave.createFromScratch(overworld.method_8412()), TAG_SAVED_DATA);
    }

    public record PerWorldEntry(class_5321<ActionRegistryEntry> key, HexDir canonicalStartDir) {
    }
}

